/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jade;

import com.mojang.datafixers.util.Pair;
import com.sihenzhang.crockpot.block.BirdcageBlock;
import com.sihenzhang.crockpot.block.entity.BirdcageBlockEntity;
import com.sihenzhang.crockpot.integration.jade.ModIntegrationJade;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.UsernameCache;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElementHelper;

public enum BirdcageProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (config.get(ModIntegrationJade.BIRDCAGE)) {
            CompoundTag serverData = accessor.getServerData();
            if (serverData.m_128441_("OwnerName")) {
                tooltip.add((Component)Component.m_237110_((String)"jade.owner", (Object[])new Object[]{serverData.m_128461_("OwnerName")}));
            } else {
                Parrot parrot;
                UUID ownerUUID;
                List<Parrot> parrots = this.getParrotsInBirdcage(accessor.getLevel(), accessor.getPosition(), accessor.getBlockState());
                if (!parrots.isEmpty() && (ownerUUID = (parrot = parrots.get(0)).m_21805_()) != null) {
                    String username = UsernameCache.getLastKnownUsername((UUID)ownerUUID);
                    tooltip.add((Component)Component.m_237110_((String)"jade.owner", (Object[])new Object[]{username == null ? "???" : username}));
                }
            }
            if (serverData.m_128425_("OutputBuffer", 9)) {
                IElementHelper elements = tooltip.getElementHelper();
                ListTag outputBuffer = serverData.m_128437_("OutputBuffer", 10);
                for (int i = 0; i < outputBuffer.size(); ++i) {
                    CompoundTag output = outputBuffer.m_128728_(i);
                    tooltip.add(elements.item(ItemStack.m_41712_((CompoundTag)output.m_128469_("Item"))));
                    float progress = (float)(40L - output.m_128454_("Time")) / 40.0f;
                    tooltip.append(elements.progress(progress, (Component)Component.m_237113_((String)((int)(progress * 100.0f) + "%")), elements.progressStyle(), (IBoxStyle)BoxStyle.DEFAULT, false).size(new Vec2(60.0f, 14.0f)).translate(new Vec2(0.0f, 4.0f)));
                }
            }
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity;
        BlockState state;
        BlockPos pos;
        Level level = accessor.getLevel();
        List<Parrot> parrots = this.getParrotsInBirdcage(level, pos = accessor.getPosition(), state = accessor.getBlockState());
        if (!parrots.isEmpty()) {
            Optional.ofNullable(parrots.get(0)).map(TamableAnimal::m_21805_).map(UsernameCache::getLastKnownUsername).ifPresent(username -> data.m_128359_("OwnerName", username));
        }
        if ((blockEntity = accessor.getBlockEntity()) instanceof BirdcageBlockEntity) {
            BirdcageBlockEntity birdcageBlockEntity = (BirdcageBlockEntity)blockEntity;
            ListTag list = new ListTag();
            for (Pair pair : birdcageBlockEntity.getOutputBuffer()) {
                CompoundTag tag = new CompoundTag();
                tag.m_128365_("Item", (Tag)((ItemStack)pair.getFirst()).serializeNBT());
                tag.m_128356_("Time", (Long)pair.getSecond() - accessor.getLevel().m_46467_());
                list.add((Object)tag);
            }
            data.m_128365_("OutputBuffer", (Tag)list);
        }
    }

    private List<Parrot> getParrotsInBirdcage(Level level, BlockPos pos, BlockState state) {
        BlockPos lowerPos = state.m_61143_(BirdcageBlock.HALF) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
        return level.m_45976_(Parrot.class, new AABB((double)lowerPos.m_123341_(), (double)lowerPos.m_123342_(), (double)lowerPos.m_123343_(), (double)lowerPos.m_123341_() + 1.0, (double)lowerPos.m_123342_() + 2.0, (double)lowerPos.m_123343_() + 1.0));
    }

    public ResourceLocation getUid() {
        return ModIntegrationJade.BIRDCAGE;
    }
}

